.\" shorthand for double quote that works everywhere.
.ds q \N'34'
.TH drmHandleEvent  __drivermansuffix__ __vendorversion__
.SH NAME
drmHandleEvent \- read and process pending DRM events
.SH SYNOPSIS
.nf
.B "#include <xf86drm.h>"

.B "typedef struct _drmEventContext {"
.BI "	int version;"
.BI "	void (*vblank_handler)(int fd,"
.BI "			       unsigned int sequence,"
.BI "			       unsigned int tv_sec,"
.BI "			       unsigned int tv_usec,"
.BI "			       void *user_data);"
.BI "	void (*page_flip_handler)(int fd,"
.BI "				  unsigned int sequence,"
.BI "				  unsigned int tv_sec,"
.BI "				  unsigned int tv_usec,"
.BI "				  void *user_data);"
.B "} drmEventContext, *drmEventContextPtr;"

.B "int drmHandleEvent(int fd, drmEventContextPtr evctx);"
.fi
.SH DESCRIPTION
This function will process outstanding DRM events on
.I fd
, which must be an open DRM device.  This function should be called after
the DRM file descriptor has polled readable; it will read the events and
use the passed-in
.I evctx
structure to call function pointers with the parameters noted above.

.SH RETURN VALUE
Returns 0 on success, or if there is no data to read from the file descriptor.
Returns -1 if the read on the file descriptor fails or returns less than a
full event record.

.SH REPORTING BUGS
Bugs in this function should be reported to http://bugs.freedesktop.org under
the "Mesa" product, with "Other" or "libdrm" as the component.

.SH "SEE ALSO"
drmModePageFlip(__libmansuffix__), drmWaitVBlank(__libmansuffix__)
