#include <param.h>

static int
setenv_cmdfunc(int argc, char **argv)
{
	return sethermit_param(argc, argv, "setenv");
}

int setenv(int argc, char **argv)
{
	return setenv_cmdfunc(argc, argv);
}

static int
clearenv_cmdfunc(int argc, char **argv)
{
	return sethermit_param(argc, argv, "clearenv");
}

int clearenv(int argc, char **argv)
{
	return clearenv_cmdfunc(argc, argv);
}
const command_t setenv_command =
	{ "setenv", "<linux options>", "set linux boot options",
	  &setenv_cmdfunc };

const command_t clearenv_command =
	{ "clearenv", "", "clear linux boot options", &clearenv_cmdfunc };

COMMAND(setenv_command);
COMMAND(clearenv_command);
