#ifndef SNORTNET_H
#define SNORTNET_H

#ifndef STD_BUF
#define STD_BUF 256
#endif

typedef struct {
	unsigned long   sensor_id;
	unsigned char   protocol;
	unsigned long   src_ip;
	unsigned long   dst_ip;
	union {
		unsigned short  src_port;
		unsigned char   icmp_type;
	}               u1;
	union {
		unsigned short  dst_port;
		unsigned char   icmp_code;
	}               u2;
#define sn_src_port u1.src_port
#define sn_dst_port u2.dst_port
#define sn_icmp_type u1.icmp_type
#define sn_icmp_code u2.icmp_code
	unsigned short  priority;
#define ALERT_PRIORITY_HIGH 1
#define ALERT_PRIORITY_LOG  0
	struct timeval  timestamp;
	unsigned long   pkt_size;
	char            msg[STD_BUF + 1];
}               NetAlert;
#endif				/* SNORTNET_H */
