/*********************************************************************
anommem.h, distributed as part of Spade v092200.1
Author: James Hoagland, Silicon Defense (hoagland@SiliconDefense.com)
copyright (c) 2000 by Silicon Defense (http://www.silicondefense.com/)
Released under GNU General Public License, see the COPYING file included
with the distribution or http://www.silicondefense.com/spice/ for details.

anommem.h is the header file for anommem.c.

Please send complaints, kudos, and especially improvements and bugfixes to
hoagland@SiliconDefense.com.  As described in GNU General Public License, no
warranty is expressed for this program.
*********************************************************************/

#ifndef ANOMMEM_H
#define ANOMMEM_H

#include "anomsensor.h"
void init_mem();
void allocate_mem_blocks();

mindex new_treeinfo(features type);
void free_treeinfo(mindex f);
mindex new_int();
void free_int(mindex f);
mindex new_leaf(valtype val);
void free_leaf(mindex f);

extern unsigned char ROOT_BLOCK_BITS;
extern unsigned char INT_BLOCK_BITS;
extern unsigned char LEAF_BLOCK_BITS;
extern unsigned int MAX_ROOT_BLOCKS;
extern unsigned int MAX_INT_BLOCKS;
extern unsigned int MAX_LEAF_BLOCKS;

#endif

/* $Id: anommem.h,v 1.4 2000/09/22 17:33:02 jim Exp $ */
