/*
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

/* $Id$ */
#ifndef __SPO_SNORTNET_H__
#define __SPO_SNORTNET_H__
#include "snort.h"

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <time.h>

#include "snortnet/snortnet.h"
#include "snortnet/libiap/iap.h"

/***********************
 * function prototypes *
 ***********************/
void SetupSnortNet(void);
void SetupAlertSnortNet(void);
void SetupLogSnortNet(void);
void AlertSnortNetInit(u_char *);
void LogSnortNetInit(u_char *);
int ParseSnortNetArgs(char *);
unsigned long ResolveHostname(char *);
void AlertSnortNet(Packet *, char *, void *);
void LogSnortNet(Packet *, char *, void *);
int MasterConnect(unsigned long , int );
void MasterReconnect(int );


/*************
 * DATATYPES *
 *************/

#endif /* __SPO_SNORTNET_H__ */
