#################################################################
# Makefile generated by Xilinx Platform Studio 
# Project:F:\Fary\EDK61-MB\system.xmp
#################################################################

# Name of the Microprocessor system
# The hardware specification of the system is in file :
# F:\Fary\EDK61-MB\system.mhs
# The software specification of the system is in file :
# F:\Fary\EDK61-MB\system.mss

SYSTEM = system

MHSFILE = system.mhs

MSSFILE = system.mss

FPGA_ARCH = virtex2p

DEVICE = XC2VP7FG456-6

LANGUAGE = vhdl

SEARCHPATHOPT = 

PLATGEN_OPTIONS = -p $(DEVICE) -lang $(LANGUAGE) $(SEARCHPATHOPT) 

LIBGEN_OPTIONS = -mhs $(MHSFILE) -p $(FPGA_ARCH) $(SEARCHPATHOPT) \
                   $(MICROBLAZE_0_LIBG_OPT)

SIM_CMD = vsim

BEHAVIORAL_DO_SCRIPT = simulation/behavioral/$(SYSTEM).do

STRUCTURAL_DO_SCRIPT = simulation/structural/$(SYSTEM).do

TIMING_DO_SCRIPT = simulation/timing/$(SYSTEM).do

DEFAULT_SIM_DO_SCRIPT = $(BEHAVIORAL_DO_SCRIPT)

SIMGEN_OPTIONS = -p $(FPGA_ARCH) -lang $(LANGUAGE) $(SEARCHPATHOPT) -s mti

MICROBLAZE_0_OUTPUT = microblaze_0/code/executable.elf
MICROBLAZE_0_XMDSTUB = microblaze_0/code/xmdstub.elf

LIBRARIES =  \
       microblaze_0/lib/libxil.a 


#################################################################
# EXTERNAL TARGETS
#################################################################
all:
	@echo "Makefile to build a Microprocessor system :"
	@echo "Run make with any of the following targets"
	@echo " "
	@echo "  netlist  : Generates the netlist for the given MHS "
	@echo "  bits     : Runs Implementation tools to generate the bitstream"
	@echo "  exporttopn:Export to ProjNav"
	@echo " "
	@echo "  libs     : Configures the sw libraries for this system"
	@echo "  program  : Compiles the program sources for all the processor instances"
	@echo "  bsp      : Generate a bsp for vxworks"
	@echo " "
	@echo "  init_bram: Initializes bitstream with BRAM data"
	@echo "  ace      : Generate ace file from bitstream and elf"
	@echo "  download : Downloads the bitstream onto the board"
	@echo " "
	@echo "  sim      : Generates HDL simulation models and runs simulator for chosen simulation mode"
	@echo "  simmodel : Generates HDL simulation models for chosen simulation mode"
	@echo "  behavioral:Generates behavioral HDL models with BRAM initialization"
	@echo "  structural:Generates structural simulation HDL models with BRAM initialization"
	@echo "  timing   : Generates timing simulation HDL models with BRAM initialization"
	@echo " "
	@echo "  netlistclean: Deletes netlist"
	@echo "  bigsclean: Deletes bit, ncd, bmm files"
	@echo "  hwclean  : Deletes implementation dir"
	@echo "  libsclean: Deletes sw libraries"
	@echo "  programclean: Deletes compiled ELF files"
	@echo "  swclean  : Deletes sw libraries and ELF files"
	@echo "  simclean : Deletes simulation dir"
	@echo "  clean    : Deletes all generated files/directories"
	@echo " "
	@echo "  make <target> : (Default)"
	@echo "      Creates a Microprocessor system using default initializations"
	@echo "      specified for each processor in MSS file"


bits: implementation/$(SYSTEM).bit

ace: implementation/$(SYSTEM).ace

netlist: implementation/$(SYSTEM).ngc

libs: $(LIBRARIES)

program: $(MICROBLAZE_0_OUTPUT) 

bsp: 
	@echo "To generate BSP, please specify VxWorks5_4/VxWorks5_5 as OS for atleast one PPC405 instance"

download: implementation/download.bit dummy
	@echo "*********************************************"
	@echo "Downloading Bitstream onto the target board"
	@echo "*********************************************"
	impact -batch etc/download.cmd

init_bram: implementation/download.bit

sim: $(DEFAULT_SIM_DO_SCRIPT)
	cd simulation/behavioral; \
	$(SIM_CMD) -do $(SYSTEM).do &

simmodel: $(DEFAULT_SIM_DO_SCRIPT)

behavioral_model: $(BEHAVIORAL_DO_SCRIPT)

structural_model: $(STRUCTURAL_DO_SCRIPT)

timing_model: $(TIMING_DO_SCRIPT)

clean: hwclean libsclean programclean simclean
	rm -f _impact.cmd

hwclean: netlistclean bitsclean
	rm -rf implementation synthesis xst hdl
	rm -rf xst.srp $(SYSTEM).srp

netlistclean:
	rm -f implementation/$(SYSTEM).ngc

bitsclean:
	rm -f implementation/$(SYSTEM).bit
	rm -f implementation/$(SYSTEM).ncd
	rm -f implementation/$(SYSTEM)_bd.bmm 

bitsclean:

simclean: 
	rm -rf simulation/behavioral

swclean: libsclean programclean
	@echo ""

libsclean: MICROBLAZE_0_LIBSCLEAN 

programclean: MICROBLAZE_0_PROGRAMCLEAN 

#################################################################
# TARGETS/MACROS FOR PROCESSOR MICROBLAZE_0
#################################################################

MICROBLAZE_0_SOURCES = code/bootloader.c code/flash.c 

MICROBLAZE_0_HEADERS = code/flash.h 

MICROBLAZE_0_CC = mb-gcc
MICROBLAZE_0_CC_SIZE = mb-size
MICROBLAZE_0_CC_OPT = -O2
MICROBLAZE_0_CFLAGS = 
MICROBLAZE_0_CC_SEARCH = # -B
MICROBLAZE_0_LIBPATH = -L./microblaze_0/lib/ # -L
MICROBLAZE_0_INCLUDES = -I./microblaze_0/include/  -Icode/ # -I
MICROBLAZE_0_LFLAGS = # -l

MICROBLAZE_0_CC_FLOW =  # -[E|S|c]
MICROBLAZE_0_CC_PREPROC_FLAG = # -Wp,
MICROBLAZE_0_CC_ASM_FLAG = # -Wa,
MICROBLAZE_0_CC_LINKER_FLAG = # -Wl,
MICROBLAZE_0_LINKER_SCRIPT = #-Wl,-T -Wl,
MICROBLAZE_0_CC_DEBUG_FLAG = # -[g|gstabs]
MICROBLAZE_0_CC_GLOBPTR_FLAG= # -mxl-gp-opt
MICROBLAZE_0_MODE = xmdstub
MICROBLAZE_0_LIBG_OPT = -$(MICROBLAZE_0_MODE) microblaze_0
MICROBLAZE_0_CC_SOFTMUL_FLAG= -mno-xl-soft-mul 
MICROBLAZE_0_CC_START_ADDR_FLAG=  # -Wl,-defsym -Wl,_TEXT_START_ADDR=
MICROBLAZE_0_CC_STACK_SIZE_FLAG=  # -Wl,-defsym -Wl,_STACK_SIZE=
MICROBLAZE_0_OTHER_CC_FLAGS= $(MICROBLAZE_0_CC_FLOW) $(MICROBLAZE_0_CC_GLOBPTR_FLAG)  \
                  $(MICROBLAZE_0_CC_START_ADDR_FLAG) $(MICROBLAZE_0_CC_STACK_SIZE_FLAG)  \
                  $(MICROBLAZE_0_CC_SOFTMUL_FLAG)  -mxl-barrel-shift -mno-xl-soft-div \
                  $(MICROBLAZE_0_CC_PREPROC_FLAG) $(MICROBLAZE_0_CC_ASM_FLAG) $(MICROBLAZE_0_CC_LINKER_FLAG)  \
                  $(MICROBLAZE_0_LINKER_SCRIPT) $(MICROBLAZE_0_CC_DEBUG_FLAG) 

$(MICROBLAZE_0_OUTPUT) : $(MICROBLAZE_0_SOURCES) $(MICROBLAZE_0_HEADERS) $(LIBRARIES) __xps/microblaze_0_compiler.opt 
	$(MICROBLAZE_0_CC) $(MICROBLAZE_0_CFLAGS) $(MICROBLAZE_0_CC_OPT) $(MICROBLAZE_0_SOURCES) -o $(MICROBLAZE_0_OUTPUT)  \
	$(MICROBLAZE_0_OTHER_CC_FLAGS) $(MICROBLAZE_0_INCLUDES) $(MICROBLAZE_0_LIBPATH)  \
	-xl-mode-$(MICROBLAZE_0_MODE)  \
	$(MICROBLAZE_0_LFLAGS) 
	$(MICROBLAZE_0_CC_SIZE) $(MICROBLAZE_0_OUTPUT) 

$(MICROBLAZE_0_XMDSTUB) : $(LIBRARIES) 

MICROBLAZE_0_LIBSCLEAN:
	rm -rf microblaze_0/lib/

MICROBLAZE_0_PROGRAMCLEAN:
	rm -f $(MICROBLAZE_0_OUTPUT) 

#################################################################
# TARGETS/MACROS FOR XILINX IMPLEMENTATION FLOW
#################################################################


implementation/download.bit: implementation/$(SYSTEM).bit  $(MICROBLAZE_0_XMDSTUB) 
	@cp -f implementation/$(SYSTEM)_bd.bmm .
	@echo "*********************************************"
	@echo "Initializing BRAM contents of the bitstream"
	@echo "*********************************************"
	bitinit $(MHSFILE) $(SEARCHPATHOPT)  -pe microblaze_0 $(MICROBLAZE_0_XMDSTUB)  -bt implementation/$(SYSTEM).bit -o implementation/download.bit
	@rm -f $(SYSTEM)_bd.bmm

implementation/$(SYSTEM).bit: implementation/$(SYSTEM).ngc etc/fast_runtime.opt __xps/xpsxflow.opt data/$(SYSTEM).ucf etc/bitgen.ut
	@echo "Copying Xilinx Implementation tool scripts.."
	@cp -f etc/bitgen.ut implementation/bitgen.ut
	@cp -f etc/fast_runtime.opt implementation/
	@cp -f data/$(SYSTEM).ucf implementation/$(SYSTEM).ucf
	@echo "*********************************************"
	@echo "Running Xilinx Implementation tools.."
	@echo "*********************************************"
	xflow -wd implementation -p $(DEVICE) -implement fast_runtime.opt $(SYSTEM).ngc
	cd implementation; bitgen -w -f bitgen.ut $(SYSTEM)

exporttopn: 
	@echo You have chosen XPS for implementation tool flow.
	@echo Please select ProjNav as your implementation flow in Project Options or use commad xset pnproj <nplfile> in batch mode

implementation/$(SYSTEM).ace:
	@echo "You must have exactly one ppc405 to generate ace file"

implementation/$(SYSTEM).ngc implementation/$(SYSTEM).bmm: \
$(MHSFILE) __xps/platgen.opt
	@echo "*********************************************"
	@echo "Creating system netlist for hardware specification.."
	@echo "*********************************************"
	platgen $(PLATGEN_OPTIONS) -st xst  $(MHSFILE)
	@echo "Running synthesis..."
	bash -c "cd synthesis; ./synthesis.sh; cd .."

$(LIBRARIES): $(MHSFILE) $(MSSFILE) __xps/libgen.opt
	@echo "*********************************************"
	@echo "Creating software libraries..."
	@echo "*********************************************"
	libgen $(LIBGEN_OPTIONS) $(MSSFILE)

#################################################################
# TARGETS/MACROS FOR SIMULATION FLOW
#################################################################


$(BEHAVIORAL_DO_SCRIPT): $(MHSFILE) __xps/simgen.opt \
 $(MICROBLAZE_0_XMDSTUB) 
	@echo "*********************************************"
	@echo "Creating behavioral simulation models..."
	@echo "*********************************************"
	simgen $(SIMGEN_OPTIONS) -m behavioral $(MHSFILE)  -pe microblaze_0 $(MICROBLAZE_0_XMDSTUB) 

$(STRUCTURAL_DO_SCRIPT): $(MHSFILE) __xps/simgen.opt \
 $(MICROBLAZE_0_XMDSTUB)  \
implementation/microblaze_0_wrapper.ngc \
implementation/mb_opb_wrapper.ngc \
implementation/debug_module_wrapper.ngc \
implementation/ilmb_wrapper.ngc \
implementation/dlmb_wrapper.ngc \
implementation/dlmb_cntlr_wrapper.ngc \
implementation/ilmb_cntlr_wrapper.ngc \
implementation/lmb_bram_wrapper.ngc \
implementation/rs232_wrapper.ngc \
implementation/leds_4bit_wrapper.ngc \
implementation/sdram_8mx32_wrapper.ngc \
implementation/opb_intc_0_wrapper.ngc \
implementation/opb_timer_0_wrapper.ngc
	@echo "*********************************************"
	@echo "Creating structural simulation models..."
	@echo "*********************************************"
	simgen $(SIMGEN_OPTIONS) -sd implementation -m structural $(MHSFILE)  -pe microblaze_0 $(MICROBLAZE_0_XMDSTUB) 

$(TIMING_DO_SCRIPT): $(MHSFILE) __xps/simgen.opt \
 $(MICROBLAZE_0_XMDSTUB)  \
implementation/$(SYSTEM).bit
	@echo "*********************************************"
	@echo "Creating timing simulation models..."
	@echo "*********************************************"
	simgen $(SIMGEN_OPTIONS) -sd implementation -m timing $(MHSFILE)  -pe microblaze_0 $(MICROBLAZE_0_XMDSTUB) 


implementation/microblaze_0_wrapper.ngc \
implementation/mb_opb_wrapper.ngc \
implementation/debug_module_wrapper.ngc \
implementation/ilmb_wrapper.ngc \
implementation/dlmb_wrapper.ngc \
implementation/dlmb_cntlr_wrapper.ngc \
implementation/ilmb_cntlr_wrapper.ngc \
implementation/lmb_bram_wrapper.ngc \
implementation/rs232_wrapper.ngc \
implementation/leds_4bit_wrapper.ngc \
implementation/sdram_8mx32_wrapper.ngc \
implementation/opb_intc_0_wrapper.ngc \
implementation/opb_timer_0_wrapper.ngc:
	platgen $(PLATGEN_OPTIONS) $(MHSFILE)

dummy:
	@echo ""

